/* XPM */
#include<stdio.h>
#include<string.h>
/* #include"logo-solid.xpm" */

char runlen[6144];
char data[4][80];
int dpos=0,runpos,runcount,runfrom,runto;

int handlebigrun(int runpos)
{
	int bigrun=(-runpos)/256;
	int shortrun=-runpos-bigrun*256;
	if(shortrun==0) {
		printf("\t;Bigrun of %d (%d)\n",bigrun*256,runpos);
		runpos=-bigrun-96;
	} else {
		printf("\t;Bigrun of %d+%d (%d)\n",bigrun*256,shortrun,runpos);
		if(bigrun>0) {
			printf("%s",data[0]);
			runlen[runcount++]=-bigrun-96;
		}
		while(shortrun>96) {
			printf("%s",data[0]);
			runlen[runcount++]=-96;
			shortrun-=96;
		}
		runpos=-shortrun;
	}
	return runpos;
}

#if 1
void coutput(char *s)
{
	runfrom++;
	if(runpos<0) {
		/* We are in a run right now */
		if(strcmp(data[0],s)==0) {
			runpos--;
		} else {
			/* We are exiting a run */
			runto++;
			printf("%s",data[0]);
			if(runpos<-96) {
				runpos=handlebigrun(runpos);
			}
			runlen[runcount++]=runpos;
			runpos=0;
			strcpy(data[0],s);
			dpos=1;
		}
	} else {
		strcpy(data[dpos++],s);
		if(dpos>3) {
			printf(";Internal error\n");
			exit(10);
		}
		if(dpos==3) {
			if( strcmp(data[0],data[1])==0 && 
				strcmp(data[0],data[2])==0) {
				/* We have a 3 byte run, so switch to a run encoding */
				if(runpos>0) {
					runlen[runcount++]=runpos;
				}
				runpos=-3;
			} else {
				/* Handle overflow */
				if(runpos==127) {
					runlen[runcount++]=runpos;
					runpos=0;
				}

				/* Make room for the next line */

				runto++;
				printf(data[0]);
				strcpy(data[0],data[1]);
				strcpy(data[1],data[2]);
				dpos--;
				runpos++;
			}
		}
	}
}

void cflush(void)
{
	int i=0;

	if(runpos<0) {
		runto++;
		printf("%s",data[0]);
		if(runpos<-96) {
			runpos=handlebigrun(runpos);
		}
		runlen[runcount++]=runpos;
		runpos=0;
	} else {
		while(dpos>0) {
			if(runpos==127) {
				runlen[runcount++]=runpos;
				runpos=0;
			}
			runto++;
			printf("%s",data[i++]);
			dpos--;
			runpos++;
		}
		runlen[runcount++]=runpos;
		runpos=0;
	}
	dpos=0;
}
		
void cruns(void)
{
	int i;
	printf(";%d byte run decoding table\n",runcount);
	for(i=0;i<runcount;i++) {
		runto++;
		printf("	DB	%d\n",runlen[i]);
	}
	runto++;
	printf("	DB	0\n");
	runcount=0;
	printf(";compressed %d => %d (%d%% compression)\n",runfrom,runto,100*runto/runfrom);
	runto=0;
	runfrom=0;
}
#else
void coutput(char *s)
{
	printf("%s",s);
	runfrom++;
}

void cflush(void)
{
}

void cruns(void)
{
	printf(";uncompressed %d\n",runfrom);
	runfrom=0;
}
#endif

char *getlabel(int i)
{
	switch(i) {
	case 0x0000:	return "RunName";
	case 0x0300:	return "RunPattern";
	/* case 0x0700:	return "RunBPattern"; */
	case 0x0b00:	return "RunColor";
	case 0x1300:	return "RunSPatt";
	case 0x1b00:	return "RunSColor";
	}
	return "Error";
}

int main(int argc, char **argv)
{
	int x,y,i,j,c;
	char s[80];
	unsigned char graph[6976];

	printf(";Parsed %s\n",argv[1]);
	FILE *file;
	file=fopen(argv[1],"rb");
	fread(graph,1,6976,file);
	fclose(file);

	printf("%s:\n",getlabel(0));
	j=0;
	for(i=0;i<6976;i++) {
		if(i==0xb00 || i==0x300 || i==0x1300 || i==0x1b00) {
			cflush();
			printf("Len%s	EQU	%d\n",getlabel(j),runcount);
			printf("Decode%s:\n",getlabel(j));
			cruns();
			printf("%s:\n",getlabel(i));
			j=i;
		}
		sprintf(s,"	DB	0%02xh\n",graph[i]);
		
		/* Check for repetition */
		coutput(s);

	}
	cflush();
	printf("Len%s	EQU	%d\n",getlabel(j),runcount);
	printf("Decode%s:\n",getlabel(j));
	cruns();

	return 0;
}
