/* Engine */
#include<stdio.h>
#include<stdlib.h>
#include "engine.h"

struct Game game;
static int dir_x[4]={-1,0,1,0},dir_y[4]={0,-1,0,1};

void new_game()
{
	game.location=-1;
	game.finances=60000;
	// Sometimes the residual values are for level to level
	game.value[0]=0;
	game.value[1]=0;
	game.value[2]=0;
	game.value[3]=0;
	game.year=0;
	game.mode=M_MENU;
}

void new_level(int level)
{
	game.mode=M_MENU;
	game.activeFur=0;
	game.quant[0]=0;
	game.quant[1]=0;
	game.quant[2]=0;
	game.quant[3]=0;
	game.location=0;
	game.year++;
}

void draw_loadfur()
{
	int i;
	int sum=0;
	
	draw_tile(T_FURRECT,0,0);
	for(i=0;i<5;i++) {
		if(game.activeFur==i) {
			draw_tile(T_FURBUTTON,25,28+38*i);
		}
		draw_tile(T_BEAVER+i,38,32+38*i);
		if(i<4) {
			draw_number(game.quant[i],176,32+38*i);
			sum+=game.quant[i];
		}
	}
	// Should also print the 190 is the goal, and what the current total is.
	draw_tile(T_CAP,192,272-48);
	draw_number(190-sum,480-288+228,272-16-8-4);
}

void draw_numpad()
{
	const int base[4]={7,4,1,0};
	int i,j,x,y;
	draw_tile(T_FURBUTTON,25,28);
	draw_tile(T_BEAVER+game.activeFur,38,32);
	draw_number(game.quant[game.activeFur],176,32);
	
	for(y=0;y<4;y++) {
		for(x=0;x<3;x++) {
			int o=0;
			i=x*48+220;
			j=y*32+72;
			if(game.numx==x && game.numy==y) o=3;
			draw_digit(10+o,i,j);
			draw_digit(11+o,i+16,j);
			draw_digit(12+o,i+32,j);
			if(y<3 || (x==0 && y==3)) {
				draw_number(x+base[y],i+18,j);
			} else {
				// Need to draw <- and <-+ (BS and ENTER)
				draw_digit(x+17,i+18,j);
			}
		}
	}
}

void draw_pickdest()
{
	int i;
	int sum=0;
	
	draw_tile(T_FURRECT,0,0);
	for(i=0;i<3;i++) {
		if(game.location==i) {
			draw_tile(T_FURBUTTON,25,28+38*i);
		}
		draw_tile(T_MONTREAL+i,38,37+38*i);
	}
	// Should print descriptions of the dest on the right
	draw_tile(T_MONTREALDESC+game.location,260,40);
	draw_tile(T_MONTREALHINT+game.location,17,148);
}

void calc_costs(int *supplies,int *expenses)
{
	*expenses=0;
	*supplies=0;
	switch(game.location) {
	case L_MONTREAL:
		*expenses=1000;
		*supplies=15000;
		break;
	case L_QUEBEC:
		*expenses=1500;
		*supplies=12500;
		break;
	case L_NEWYORK:
		*expenses=2500;
		*supplies=8000;
		break;
	}
}

void draw_finish()
{
	int i;
	int x=270;
	
	draw_tile(T_FURRECT,0,0);
	draw_tile(T_FURRECT,64,0);
	draw_tile(T_SUMMARY,17,12);
	draw_number(game.year,156,18);
	int sub=0;
	for(i=0;i<4;i++) {
		int amt=game.value[i]*game.quant[i];
		draw_money(game.value[i],150,44+i*21);
		draw_number(game.quant[i],187,44+i*21);
		draw_money(amt,x,44+i*21);
		sub+=amt;
	}
	draw_money(sub,x,44+i++*21);
	int expenses=0,supplies=0;
	calc_costs(&supplies,&expenses);
	draw_money(expenses,x,44+i*21);
	i++;
	draw_money(supplies,x,44+i*21);
	i++;
	int trip=sub-expenses-supplies;
	draw_money(trip,x,44+i*21);
	i++;
	draw_money(game.finances+trip,x,44+i*21);
	i++;

	draw_tile(T_FURBUTTON,325,225);
	draw_tile(T_NEXT,338,228);
}

void draw_map()
{
	draw_tile(T_BG,0,0);
	switch(game.mode) {
	case M_MENU:
		draw_tile(T_TITLE,0,0);
		break;
	case M_LOADFUR:
		draw_loadfur();
		break;
	case M_NUMPAD:
		draw_numpad();
		break;
	case M_PICKDEST:
		draw_pickdest();
		break;
	case M_BATTLE:
		draw_tile(game.disaster,216,8);
		draw_tile(T_FURBUTTON,25,25);
		draw_tile(T_NEXT,38,28);
		break;
	case M_FINISH:
		draw_finish();
		break;
	}
}

void move_character(int direction)
{
	switch(game.mode) {
	case M_MENU:
		break;
	case M_LOADFUR:
		if(direction==D_UP) {
			if(game.activeFur>0) {
				game.activeFur--;
			}
		} else if(direction==D_DOWN) {
			if(game.quant[0]+game.quant[1]+game.quant[2]+game.quant[3]>190) {
				if(game.activeFur<3) {
					// Can't go to next if there are more than 190 furs in total
					game.activeFur++;
				}
			} else if(game.activeFur<4) {
				game.activeFur++;
			}
		}
		break;
	case M_NUMPAD:
		switch(direction) {
		case D_LEFT:
			if(game.numx>0) game.numx--;
			break;
		case D_RIGHT:
			if(game.numx<2) game.numx++;
			break;
		case D_UP:
			if(game.numy>0) game.numy--;
			break;
		case D_DOWN:
			if(game.numy<3) game.numy++;
			break;
		}
		break;
	case M_PICKDEST:
		if(direction==D_UP) {
			if(game.location>0) {
				game.location--;
			}
		} else if(direction==D_DOWN) {
			if(game.location<2) {
				game.location++;
			}
		}
		break;
	}
}

void explode_pickdest()
{
	game.mode=M_FINISH;	// Unless we are unlucky.
	
	switch(game.location) {
	case L_MONTREAL:
		// Easy route
		game.value[0]=(rand()%20)+75;	// Beaver
		game.value[1]=(rand()%20)+80;	// Fox
		game.value[2]=(rand()%20)+65;	// Ermine
		game.value[3]=(rand()%20)+70;	// Mink
		return;
	case L_QUEBEC:
		// Medium route
		game.value[0]=(rand()%20)+90;	// Beaver
		//game.value[1]=0;	// Fox	-- only good if you sold them before
		game.value[2]=(rand()%15)+80;	// Ermine
		game.value[3]=(rand()%30)+85;	// Mink
		game.disaster=rand()%10;
		if(game.disaster>8) break;	// Made it safely.
		game.mode=M_BATTLE;
		if(game.disaster<=2) {
			game.quant[F_BEAVER]=0;		// Stolen during portage
			game.disaster=T_BEAVERSTOLEN;
		} else if(game.disaster<=6) {
			game.quant[0]=0;	// Dumped in strathcona rapids
			game.quant[1]=0;
			game.quant[2]=0;
			game.quant[3]=0;
			game.disaster=T_STRATHCONARAPIDS;
		} else {
			game.quant[F_FOX]=0;	// Fox not cured properly
			game.disaster=T_FOXNOTCURED;
		}
		break;
	case L_NEWYORK:
		// Hard route
		//game.value[0]=0;	// Beaver - Only if you sold them before
		game.value[1]=(rand()%25)+110;	// Fox
		//game.value[2]=0;	// Ermine - Only if you sold them before
		game.value[3]=(rand()%15)+105;	// Mink
		game.disaster=rand()%10;
		if(game.disaster<=2) {
			game.disaster=T_IROQUOISSLAUGHTER;
			game.mode=M_BATTLE;
		} else if(game.disaster<=6) {
			game.mode=M_FINISH;	// Arrived safely
		} else if(game.disaster<=8) {
			game.disaster=T_HALFBEAVERMINK;
			game.mode=M_BATTLE;
			game.value[F_BEAVER]/=2;
			game.value[F_MINK]/=2;
		} else {
			game.mode=M_BATTLE;
			game.disaster=T_IROQUOISESCAPE;
			game.quant[0]=0;
			game.quant[1]=0;
			game.quant[2]=0;
			game.quant[3]=0;
		}
	}
}

void update_finances()
{
	int sub=0;
	int i;
	for(i=0;i<4;i++) {
		int amt=game.value[i]*game.quant[i];
		sub+=amt;
	}
	int expenses=0,supplies=0;
	calc_costs(&supplies,&expenses);
	int trip=sub-expenses-supplies;
	game.finances+=trip;
	if(game.finances<0) game.finances=0;
}

void explode_path()
{
	switch(game.mode) {
	case M_MENU:
		game.mode=M_LOADFUR;
		break;
	case M_LOADFUR:
		if(game.activeFur>3) {
			game.mode=M_PICKDEST;
		} else {
			game.mode=M_NUMPAD;
			game.numx=0;
			game.numy=0;
		}
		break;
	case M_NUMPAD:
		if(game.numx==1 && game.numy==3) {	// Backspace
			game.quant[game.activeFur]/=10;
		} else if(game.numx==2 && game.numy==3) {  // Enter
			game.mode=M_LOADFUR;
		} else {
			// Map to number
			const int base[4]={7,4,1,0};
			game.quant[game.activeFur]*=10;
			game.quant[game.activeFur]%=1000;
			game.quant[game.activeFur]+=game.numx+base[game.numy];
		}
		break;
	case M_PICKDEST:
		explode_pickdest();
		break;
	case M_BATTLE:
		if(game.disaster==T_IROQUOISSLAUGHTER) {
			new_game();
			new_level(1);
			break;
		}
		game.mode=M_FINISH;
		break;
	case M_FINISH:
		update_finances();
		new_level(1);
		game.mode=M_LOADFUR;
		break;
	}
}

void next_frame(int elapsed)
{
}
