// Engine.h -- Game engine

#define TILEWIDTH 16
#define TILEHEIGHT 32

#define D_NONE -1
#define D_LEFT 0
#define D_UP 1
#define D_RIGHT 2
#define D_DOWN 3

struct Game {
	int mode;
	int activeFur;
	int numx,numy;
	int quant[4];
	int value[4];
	int location;
	int disaster;
	int finances;
	int year;
};

#define M_MENU 0
#define M_LOADFUR 1
#define M_NUMPAD 2
#define M_PICKDEST 3
#define M_BATTLE 4
#define M_FINISH 5

#define F_BEAVER 0
#define F_FOX 1
#define F_ERMINE 2
#define F_MINK 3

#define L_MONTREAL 0
#define L_QUEBEC 1
#define L_NEWYORK 2

#define D_NONE -1
#define D_LEFT 0
#define D_UP 1
#define D_RIGHT 2
#define D_DOWN 3

#define T_BEAVER 0
#define T_FOX 1
#define T_ERMINE 2
#define T_MINK 3
#define T_NEXT 4
#define T_BG 5
#define T_TITLE 6
#define T_FURRECT 7
#define T_FURBUTTON 8
#define T_MONTREAL 9
#define T_QUEBEC 10
#define T_NEWYORK 11
#define T_MONTREALDESC 12
#define T_QUEBECDESC 13
#define T_NEWYORKDESC 14
#define T_SAFE 15
#define T_BEAVERSTOLEN 16
#define T_STRATHCONARAPIDS 17
#define T_FOXNOTCURED 18
#define T_IROQUOISSLAUGHTER 19
#define T_HALFBEAVERMINK 20
#define T_IROQUOISESCAPE 21
#define T_SUMMARY 22
#define T_CAP 23
#define T_MONTREALHINT 24
#define T_QUEBECHINT 25
#define T_NEWYORKHINT 26
#define T_MAX 27

extern struct Game game;
// Engine implemented
void new_game();
void new_level(int level);
void next_frame(int elapsed);
void draw_map();
void move_character(int direction);
void explode_path();
// SDL implemented
void draw_tile(int id,int x,int y);
void draw_number(int num,int x,int y);
void draw_money(int num,int x,int y);
void draw_digit(int id,int x,int y);
