#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <SDL/SDL.h>

#ifdef _WIN32
#include <windows.h>
#endif
#include "engine.h"

/*
 PLEASE NOTE: the program will require SDL.dll which is located in
              dev-c++'s dll directory. You have to copy it to you
			  program's home directory or the path.
 */

/* The screen surface */
SDL_Surface *screen = NULL;
SDL_Surface *numbers=NULL;
SDL_Surface *tile[T_MAX];
static char *tilename[T_MAX]={
	"beaver.bmp",
	"fox.bmp",
	"ermine.bmp",
	"mink.bmp",
	"next.bmp",
	"background.bmp",
	"title.bmp",
	"bgrect.bmp",
	"furbutton.bmp",
	"montreal.bmp",
	"quebec.bmp",
	"newyork.bmp",
	"montrealdesc.bmp",
	"quebecdesc.bmp",
	"newyorkdesc.bmp",
	"safe.bmp",
	"beaverstolen.bmp",
	"strathconarapids.bmp",
	"foxnotcured.bmp",
	"iroquoisslaughter.bmp",
	"halfbeavermink.bmp",
	"iroquoisescape.bmp",
	"summary.bmp",
	"cap.bmp",
	"montrealhint.bmp",
	"quebechint.bmp",
	"newyorkhint.bmp",
};

/* This function draws to the screen; replace this with your own code! */
static void draw()
{
	draw_map();

    /* Make sure everything is displayed on screen */
    SDL_Flip (screen);
    /* Don't run too fast */
    SDL_Delay (50);
}

/* Returns width */
void draw_digit(int id,int x,int y)
{
    SDL_Rect tileRect;
    SDL_Rect rect;
	
	rect.x=x;
	rect.y=y;
	rect.w=TILEWIDTH;
	rect.h=TILEHEIGHT;
	if(numbers) {
		tileRect.x=id*TILEWIDTH;
		tileRect.y=0;
		tileRect.w=TILEWIDTH;
		tileRect.h=TILEHEIGHT;
		SDL_BlitSurface(numbers,&tileRect,screen,&rect);
	} else {
	    Uint32 color;
	
	    /* Create a black background */
	    color = SDL_MapRGB (screen->format, id&4?255:0, id&2?255:0, id&1?255:0);
		SDL_FillRect(screen,&rect,color);
	}
}

/* Returns width */
void draw_tile(int id,int x,int y)
{
    SDL_Rect tileRect;
    SDL_Rect rect;
	
	if(id<0 || id>=T_MAX) return;	// Just for safety
	if(tile[id]==NULL) {
	    Uint32 color;

		rect.x=x;
		rect.y=y;
		rect.w=TILEWIDTH;
		rect.h=TILEHEIGHT;
	    /* Create a black background */
	    color = SDL_MapRGB (screen->format, id&4?255:0, id&2?255:0, id&1?255:0);
		SDL_FillRect(screen,&rect,color);
	} else {
		rect.x=x;
		rect.y=y;
		rect.w=tile[id]->h;
		rect.h=tile[id]->w;
		SDL_BlitSurface(tile[id],0,screen,&rect);
	}
}

void draw_number(int num,int x,int y)
{
	int i;
	int max=1;
	int sign=0;
	
	if(num<0) {
		sign=1;
		num=-num;
	}
	if(num>9999999) max=8;
	else if(num>999999) max=7;
	else if(num>99999) max=6;
	else if(num>9999) max=5;
	else if(num>999) max=4;
	else if(num>99) max=3;
	else if(num>9) max=2;
	for(i=0;i<max;i++) {
		draw_digit(num%10,x,y);
		num/=10;
		x-=12;
	}
	if(sign) draw_digit(16,x,y);
}

void draw_money(int num,int x,int y)
{
	int i;
	int max=3;
	int sign=0;
	
	if(num<0) {
		sign=1;
		num=-num;
	}
	if(num>9999999) max=8;
	else if(num>999999) max=7;
	else if(num>99999) max=6;
	else if(num>9999) max=5;
	else if(num>999) max=4;
	for(i=0;i<max;i++) {
		draw_digit(num%10,x,y);
		num/=10;
		x-=12;
		if(i==1) {
			draw_digit(17,x+8,y);
			x-=6;
		}
	}
	if(sign) draw_digit(16,x,y);
}

int
main (int argc, char *argv[])
{
    char *msg;
    int done;
    int i;

    /* Initialize SDL */
    if (SDL_Init (SDL_INIT_VIDEO|SDL_INIT_JOYSTICK) < 0)
    {
#ifdef _WIN32
        sprintf (msg, "Couldn't initialize SDL: %s\n", SDL_GetError ());
        MessageBox (0, msg, "Error", MB_ICONHAND); 
        free (msg);
#endif
        exit (1);
    }
    atexit (SDL_Quit);

    /* Set 640x480 16-bits video mode */
    screen = SDL_SetVideoMode (480, 272, 16, SDL_SWSURFACE | SDL_DOUBLEBUF);
    if (screen == NULL)
    {
#ifdef _WIN32
        sprintf (msg, "Couldn't set 480x272x16 video mode: %s\n",
          SDL_GetError ());
        MessageBox (0, msg, "Error", MB_ICONHAND); 
        free (msg);
#endif
        exit (2);
    }
    SDL_WM_SetCaption ("Fur Trader SDL by Dale Wick", NULL);

//    gfx=SDL_LoadBMP("gfx.bmp");
//    if(gfx) SDL_SetColorKey(gfx, SDL_SRCCOLORKEY, SDL_MapRGB(gfx->format, 0, 255, 0));
    numbers=SDL_LoadBMP("numbers.bmp");
    if(numbers) SDL_SetColorKey(numbers, SDL_SRCCOLORKEY, SDL_MapRGB(numbers->format, 192, 192, 192));
	for(i=0;i<T_MAX;i++) {
	    tile[i]=SDL_LoadBMP(tilename[i]);
	    if(tile[i]) SDL_SetColorKey(tile[i], SDL_SRCCOLORKEY, SDL_MapRGB(tile[i]->format, 192, 192, 192));
	}

	SDL_Joystick *joy=0;
	if(SDL_NumJoysticks()>0)
	   joy=SDL_JoystickOpen(0);
	
	int start=0;
    done = 0;

	new_game();
	new_level(1);
    int oldTime=SDL_GetTicks();
	srand(oldTime);

	int dir=-1;
    while (!done)
    {
        SDL_Event event;

        /* Check for events */
        while (SDL_PollEvent (&event))	// PollEvent
        {
            switch (event.type)
            {
            case SDL_KEYDOWN:
                if(event.key.keysym.sym == SDLK_ESCAPE) done=1;
                if(event.key.keysym.sym == SDLK_SPACE) explode_path();
				if(event.key.keysym.sym == SDLK_LEFT) dir=0;
				if(event.key.keysym.sym == SDLK_UP) dir=1;
				if(event.key.keysym.sym == SDLK_RIGHT) dir=2;
				if(event.key.keysym.sym == SDLK_DOWN) dir=3;
                break;
            case SDL_KEYUP:
				if(event.key.keysym.sym == SDLK_LEFT && dir==0) dir=-1;
				if(event.key.keysym.sym == SDLK_UP && dir==1) dir=-1;
				if(event.key.keysym.sym == SDLK_RIGHT && dir==2) dir=-1;
				if(event.key.keysym.sym == SDLK_DOWN && dir==3) dir=-1;
				break;
            case SDL_JOYBUTTONDOWN:
                if(event.jbutton.button == 10 /* SELECT */) done=1;
                if(event.jbutton.button == 2 /* CROSS */) explode_path();
				if(event.jbutton.button == 7 /* LEFT */) dir=0;
				if(event.jbutton.button == 8 /* UP */) dir=1;
				if(event.jbutton.button == 9 /* RIGHT */) dir=2;
				if(event.jbutton.button == 6 /* DOWN */) dir=3;
				break;
            case SDL_JOYBUTTONUP:
				if(event.jbutton.button == 7 /* LEFT */ && dir==0) dir=-1;
				if(event.jbutton.button == 8 /* UP */ && dir==1) dir=-1;
				if(event.jbutton.button == 9 /* RIGHT */ && dir==2) dir=-1;
				if(event.jbutton.button == 6 /* DOWN */ && dir==3) dir=-1;
				break;
            case SDL_QUIT:
                done = 1;
                break;
            default:
                break;
            }
        }
        if(dir>=0) move_character(dir);

        /* Draw to screen */
		int newTime=SDL_GetTicks();
        next_frame(newTime-oldTime);
        oldTime=SDL_GetTicks();
        draw ();
    }

    return 0;
}
